#!/bin/bash
exp_id=$1
num_shadow=$2

DATA_PATH="datasets"  # path to cifar10
SYN_PATH="exps/mtt_cinic_init/syn_img"  # path to save synthetic images
LIRA_PATH="exps/mtt_cinic_init/lira"  # path to save in-out-split indices, noisy targets and canary indices
METHOD="MTT"

python src/LiRA/train.py \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --data_path $DATA_PATH \
    --lira_path $LIRA_PATH \
    --syn_data_path $SYN_PATH \
    --epochs 200 \
    --lr_net 0.1 \
    --model_type ResNet18 \
    --method $METHOD \
    --num_canaries 500 \
